# 機能設計書 68-Boot Environment管理

## 概要

本ドキュメントは、ZFSブート環境（Boot Environment）の作成・管理・切替を行うbectlコマンドの機能設計を記述する。bectlはZFSスナップショットとクローン機能を活用し、システムのブート可能な状態を管理する。

### 本機能の処理概要

**業務上の目的・背景**：システムアップデートやパッケージ更新時にロールバック可能な状態を保持することは、システムの可用性と安定性の確保に不可欠である。ZFS Boot Environment（BE）は、ZFSのスナップショットとクローン機能を利用して、ブート可能なファイルシステムの状態を複数保持し、安全な切り替えを可能にする。

**機能の利用シーン**：FreeBSDのシステムアップデート前のBE作成、アップデート失敗時の前バージョンへのロールバック、新しい設定のテスト（一時アクティベーション）、システム状態のスナップショット管理、BEのjail化によるテスト実行に使用される。

**主要な処理内容**：
1. BEの作成（ZFSスナップショット/クローン作成）
2. BEのアクティベーション（次回ブート対象の設定）
3. BEの一時アクティベーション（1回限りのブート対象変更）
4. BEの削除（ZFSクローン/スナップショットの破棄）
5. BE一覧の表示（ZFSデータセット情報の整形表示）
6. BEのエクスポート/インポート（ZFS send/receive）
7. BEのマウント/アンマウント
8. BEのjail化（BEをjail環境としてマウント・実行）
9. BEの名前変更

**関連システム・外部連携**：libbe ライブラリがZFS操作の抽象化レイヤを提供する。ZFSカーネルモジュールおよびlibzfsと連携してデータセット操作を行う。jail(8)と連携してBEのjail化を実現する。

**権限による制御**：bectl操作にはroot権限が必要（ZFSデータセット操作のため）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能にはGUI画面の関連はない |

## 機能種別

ZFSブート環境管理 / スナップショット管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -r beroot | string | No | BEルートデータセット | 有効なZFSデータセット |
| activate [-t] beName | string | Yes | BEアクティベーション（-tで一時的） | 存在するBE名 |
| activate [-T] | flag | No | 一時アクティベーション解除 | なし |
| create [-r] [-e source] beName | string | Yes | BE作成（-rで再帰的、-eでソース指定） | 一意のBE名 |
| destroy [-Fo] beName | string | Yes | BE削除（-Fで強制、-oでオリジンも） | 存在するBE名 |
| list [-aDHs] | flag | No | BE一覧表示 | なし |
| mount beName [mountpoint] | string | Yes | BEマウント | 存在するBE名 |
| unmount [-f] beName | string | Yes | BEアンマウント（-fで強制） | マウント済みBE名 |
| jail beName [utility] | string | Yes | BEをjail化して実行 | 存在するBE名 |
| rename origBe newBe | string | Yes | BE名変更 | 両方有効な名前 |
| export sourceBe | string | Yes | BEエクスポート（stdin出力） | 存在するBE名 |
| import targetBe | string | Yes | BEインポート（stdin入力） | 一意のBE名 |
| check | flag | No | BEサポート確認 | なし |

### 入力データソース

- コマンドライン引数
- ZFSプール情報（libbe経由）
- 標準入力（import時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| BE一覧 | text | 名前、アクティブ状態、マウントポイント、サイズ、作成日時 |
| 操作結果 | text | 成功/失敗メッセージ |
| エクスポートデータ | bytes | ZFS send形式のバイトストリーム |

### 出力先

- 標準出力: BE一覧、操作結果、エクスポートデータ
- ZFSプール: BE作成/削除/名前変更

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ libbe_init()によるlibbeハンドル取得、BEルートの決定
2. コマンドパース
   └─ command_map配列によるサブコマンドディスパッチ
3. サブコマンド実行
   └─ libbe APIを通じたZFS操作
4. 結果出力
   └─ 操作結果の表示
5. クリーンアップ
   └─ libbe_close()によるリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[bectl起動] --> B[libbe_init]
    B --> C[サブコマンド解析]
    C --> D{サブコマンド}
    D -->|activate| E[be_activate]
    D -->|create| F[be_snapshot/be_create]
    D -->|destroy| G[be_destroy]
    D -->|list| H[be_get_bootenv_props]
    D -->|jail| I[bectl_cmd_jail]
    D -->|mount| J[be_mount]
    D -->|export| K[be_export]
    D -->|import| L[be_import]
    E --> M[結果表示]
    F --> M
    G --> M
    H --> M
    I --> M
    J --> M
    K --> M
    L --> M
    M --> N[libbe_close]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-68-01 | アクティブBE保護 | 現在アクティブなBEは削除不可（-Fで強制削除は可） | destroy操作時 |
| BR-68-02 | 一時アクティベーション | -tオプションで次回ブートのみ有効なアクティベーション | activate -t時 |
| BR-68-03 | スナップショット作成 | BE名に@を含む場合はスナップショットとして作成 | create時 |
| BR-68-04 | 再帰的クローン | -rオプションで子データセットも含めてクローン | create -r時 |
| BR-68-05 | 履歴記録 | save_history=trueのコマンドはZFSプール履歴に記録 | command_map定義による |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。ZFSプールのメタデータがBE情報を管理する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EX_USAGE | 引数不正 | サブコマンドやオプションが不正 | usage表示 |
| - | BE作成失敗 | ZFSプール容量不足やスナップショット数上限 | 容量確保 |
| - | アクティベーション失敗 | 指定BEが存在しない | BE名確認 |
| - | 削除失敗 | 依存関係がある（クローンの元スナップショット等） | -oでオリジンも削除 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

ZFSの操作はZFS自身のトランザクション機構に依存する。

## パフォーマンス要件

- ZFSクローンの作成はCopy-on-Writeにより瞬時に完了
- BE一覧表示はZFSメタデータの読み取りのみで高速

## セキュリティ考慮事項

- root権限が必要
- BEのjail化は標準のjailセキュリティモデルに従う

## 備考

- libbe (lib/libbe/) がBE操作の抽象化レイヤを提供
- bectl_jail.c がjail関連のサブコマンドを実装
- bectl_list.c がlist関連のサブコマンドを実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bectl.h | `sbin/bectl/bectl.h` | bectl内部ヘッダ、libbe_handle_tグローバル変数 |
| 1-2 | be.h | ライブラリヘッダ | libbe API定義（be_activate, be_create等） |

**読解のコツ**: bectlは薄いコマンドラインラッパーであり、実際のBE操作はlibbeライブラリが行う。command_map配列でサブコマンドと関数のマッピングを理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bectl.c | `sbin/bectl/bectl.c` | main()とcommand_map配列 |

**主要処理フロー**:
1. **7行目**: bectl.hインクルード
2. **21行目**: be.hインクルード（libbeライブラリ）
3. **25-36行目**: サブコマンド関数宣言
4. **38行目**: libbe_handle_t *be グローバルハンドル
5. **40-68行目**: usage()関数 - 全サブコマンドのヘルプ
6. **75-81行目**: command_map_entry構造体（command, fn, silent, save_history）
7. **83-102行目**: command_map配列 - サブコマンドと関数のマッピング
8. **117-174行目**: bectl_cmd_activate() - アクティベーションロジック
9. **181-199行目**: bectl_cmd_create() - BE作成ロジック

#### Step 3: jail連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bectl_jail.c | `sbin/bectl/bectl_jail.c` | BEのjail化処理 |

#### Step 4: 一覧表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bectl_list.c | `sbin/bectl/bectl_list.c` | BE一覧表示処理 |

### プログラム呼び出し階層図

```
main() [bectl.c]
    |
    +-- libbe_init() [libbe]
    |
    +-- get_cmd_info() [bectl.c:104-115]
    |
    +-- サブコマンド実行
    |       +-- bectl_cmd_activate() → be_activate()/be_deactivate() [libbe]
    |       +-- bectl_cmd_create() → be_snapshot()/be_create() [libbe]
    |       +-- bectl_cmd_destroy() → be_destroy() [libbe]
    |       +-- bectl_cmd_list() [bectl_list.c] → be_get_bootenv_props() [libbe]
    |       +-- bectl_cmd_jail() [bectl_jail.c] → be_mount() + jail_set()
    |       +-- bectl_cmd_mount() → be_mount() [libbe]
    |       +-- bectl_cmd_export() → be_export() [libbe]
    |       +-- bectl_cmd_import() → be_import() [libbe]
    |
    +-- libbe_close() [libbe]
```

### データフロー図

```
[入力]                      [処理]                        [出力]

コマンドライン ──────▶ bectl.c main() ──────────▶ サブコマンド実行
                              |
ZFSプール情報 ◀──────▶ libbe ライブラリ ◀──▶ ZFSデータセット操作
                              |
標準入力 ────────────▶ import ────────────────▶ ZFSデータセット
                              |
ZFSデータセット ─────▶ export ────────────────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bectl.c | `sbin/bectl/bectl.c` | ソース | メインエントリポイント |
| bectl.h | `sbin/bectl/bectl.h` | ヘッダ | 内部ヘッダ |
| bectl_jail.c | `sbin/bectl/bectl_jail.c` | ソース | jail関連サブコマンド |
| bectl_list.c | `sbin/bectl/bectl_list.c` | ソース | list関連サブコマンド |
| bectl.8 | `sbin/bectl/bectl.8` | マニュアル | bectlマニュアルページ |
